### 配置参数定义

模块配置一共有8个配置参数，如下表所示。

| **功能** | **参数名** | **取值范围** | **默认值** |
|---|---|---|---|
| 编码器SSI帧长度 | E0 Frame Length | 10~40 | 13 |
| 编码器读取数据时的时钟频率 | E0 Clock Frequency | 0：2MHz | 0 |
| 1：1.5MHz |
| 2：1MHz |
| 3：500KHz |
| 4：250KHz |
| 5：125KHz |
| 编码器间隔时间 | E0 Interval Time | 1~50000（单位：100us） | 1 |
| 编码器编码方式 | E0 Encoder Type | 0：Binary（二进制码） | 1 |
| 1：Gray（格雷码） |
| 编码器位置值的LSB位号 | E0 LSB Position | 0~39 | 0 |
| 编码器位置值的MSB位号 | E0 MSB Position | 1~40 | 12 |
| 编码器0探针模式 | E0 Latch Mode | 0：CH0 Single，CH1 Single通道0单次、通道1单次 | 0 |
| 1：CH0 Repeat，CH1 Single通道0重复、通道1单次 |
| 2：CH0 Single，CH1 Repeat通道0单次、通道1重复 |
| 3：CH0 Repeat，CH1 Repeat通道0重复、通道1重复 |
| 编码器0探针触发边沿 | E0 Latch Edge | 0：CH0 Raising，CH1 Raising通道0上升沿、通道1上升沿 | 0 |
| 1：CH0 Falling，CH1 Raising通道0下降沿、通道1上升沿 |
| 2：CH0 Raising，CH1 Falling通道0上升沿、通道1下降沿 |
| 3：CH0 Falling，CH1 Falling通道0下降沿、通道1下降沿 |



参数说明：

- 编码器SSI帧长度Frame Length
- 位置值的LSB位号LSB Position
- 位置值的MSB位号MSB Position

帧长度参数，结合位置号LSB和MSB参数可以设置编码器计数的分辨率和总计数值，分辨率即编码器每转一圈增加的数值。

- 读取数据时的时钟频率Clock Frequency

时钟频率默认取值为0，即2MHz。

- 间隔时间Interval Time

默认取值为1，即100us，可设置范围1~50000（100us）。

- 编码器编码方式 Encoder Type

默认取值为1，即使能格雷码转换。设置为0则禁止格雷码转换，使用二进制码。

探针功能参数包括探针模式Latch Mode和探针触发边沿Latch Edge两项参数。每路编码器配备2路探针输入通道，通过对探针输入通道输入对应信号，可以锁存对应编码器的计数值。

- 探针模式：探针模式参数可配置编码器每个探针功能通道为单次/连续模式。

探针功能通道配置为单次模式，则探针功能使能后，通道输入满足设定条件的信号时，可锁存一次计数值；后续再次输入满足设定条件的信号时，不再进行锁存，除非重新使能该探针功能通道。

探针功能通道配置为连续模式，则探针功能使能后，每次通道输入满足设定条件的信号，均可锁存一次计数值，即可多次锁存计数值。

- 探针触发边沿：通过探针触发边沿参数可配置编码器每个探针功能通道为上升沿/下降沿触发。每路编码器的两个探针功能通道锁存触发信号可单独配置，锁存数值可以单独显示。

探针输入通道通过COM端兼容PNP/NPN信号。当COM端接入0V时，输入信号为PNP型，输入高电平24V信号有效，输入低电平0V信号无效；当COM端接入24V时，输入信号为NPN型，输入低电平0V信号有效，输入高电平24V信号无效。

上升沿触发表示探针输入通道从无效信号到有效信号触发，下降沿触发表示从有效信号到无效信号触发。